package gov.va.med.domain.service.messaging.encode.hl7;

import gov.va.med.domain.model.IPayload;
import gov.va.med.domain.service.messaging.MessagingConstants;
import gov.va.med.domain.service.messaging.MessagingException;
import gov.va.med.domain.service.messaging.encode.hl7.util.HL7HeaderParameters;
import gov.va.med.domain.service.messaging.encode.hl7.util.HL7v24Helper;
import gov.va.med.domain.service.messaging.environment.EndPoint;
import gov.va.med.domain.service.messaging.parse.HL7MessageMetadata;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;

/**
 * HL7ApplicationAckEncoder
 *
 * @author Slava Uchitel
 * @version $Id: HL7ApplicationAckEncoder.java,v 1.5 2005/04/22 02:21:19 slava.uchitel Exp $
 * @since MHV 2.1 <br>Apr 3, 2005
 */
public abstract class HL7ApplicationAckEncoder extends HL7MessageEncoder {
	protected void fillMSHSegment(MSH msh, HL7MessageMetadata metaData)
	    throws DataTypeException {
		HL7HeaderParameters params = buildHL7HeaderParameters(metaData);
		HL7v24Helper.fillMSHSegment(msh, params);
	}

	protected HL7HeaderParameters buildHL7HeaderParameters(HL7MessageMetadata metaData) {
		HL7HeaderParameters params = new HL7HeaderParameters();
		params.setSrcStationNumber(metaData.getReceivingSystemId());
		params.setSrcDomain(metaData.getReceivingSystemDomain());
		params.setSrcApplication(metaData.getReceivingApplication());
		params.setDstStationNumber(metaData.getSendingSystemId());
		params.setDstDomain(metaData.getSendingSystemDomain());
		params.setDstApplication(metaData.getSendingApplication());
		params.setSystemType(metaData.getSystemType());
		params.setFieldSeparator(DEFAULT_FIELD_SEPARATOR);
		params.setDelimiters(DEFAULT_DELIMITERS);
		params.setEvent(metaData.getMessageType());
		params.setTrigger(metaData.getTriggerEvent());
		params.setMessageStructure(metaData.getMessageType() + "_" + metaData.getTriggerEvent());
		params.setAcceptAcknowledgmentType(MessagingConstants.ALWAYS_ACKNOWLEDGE);
		params.setApplicationAcknowledgmentType(MessagingConstants.NEVER_ACKNOWLEDGE);
		return params;
	}

	//This method must be overridden in concrete 
	//implementation to produce appropriate message.
	protected abstract Message createMessage(HL7MessageMetadata metaData) 
		throws EncodingNotSupportedException, DataTypeException, HL7Exception;
	public Object encode(IPayload payload, EndPoint ep)
	    throws MessagingException {
		HL7MessageMetadata metaData = (HL7MessageMetadata)payload;
		try {
			Message ack = createMessage(metaData);
			Parser parser = new PipeParser();
			return parser.encode(ack);
		}
		catch(DataTypeException e) {
			String msg = "Failed while encoding a request message into HL7.";
			getLogger().error(msg + ". Error: " + e.getMessage());
			throw new MessagingException(msg);
		}
		catch(HL7Exception e) {
			String msg = "Failed while encoding a request message into HL7.";
			getLogger().error(msg + ". Error: " + e.getMessage());
			throw new MessagingException(msg);
		}
	}

}
